
-- Spell effects are drawn differently depending on whether they are tagged as "moving".
-- Stationary spell effects behave very much like character models.
-- Moving spell effects are intended to display particle trails as they move,
--		so they must properly move around within their frame (which takes up the entire window).
-- Important effects, such as telegraphs and void zones, should always be stationary.
-- 		Stationary effects are positioned more accurately than moving effects.


-- This is the "new version" of SpellEffect where we keep a single calculation for minimum possible effect size
-- and scale the frame up instead of changing camera scale.





TRAININGGROUNDS_Drawable_SpellEffect = TRAININGGROUNDS_inheritsFrom(TRAININGGROUNDS_Drawable)

function TRAININGGROUNDS_Drawable_SpellEffect:SetCustomInfo()
	TRAININGGROUNDS_Drawable.SetCustomInfo(self)
	--self.moving=false
	self.moving=true
	self.anchor="CENTER"
	
	--solarwrath:
	self.modelfilename="spells/cfx_druid_solarwrath_missile.m2"
	self.yoffset=-1	
	self.cameradistance=3	
	self.framescale=2
	-- moving spelleffect parameters:
	-- This multiplier affects SetCamDistanceScale.  The SMALLER multiplier is, the LARGER the effect will appear.
	self.movingyoffset=-1
	-- The minimum width/height allowed.  Below this size, the effect will switch to stationary mode.
	self.minsize=10
	-- The camera scale used at the minimum size.  (Larger camera scale makes for smaller size.)
	self.minscale=80
	self.multiplierbase=800
	self.mobilexmodifier=1
	self.mobilexmultipliermodifier=0.5
	self.mobileymodifier=1.2
	self.mobileymultipliermodifier=0.5
	
	-- --chiorbit:		
	-- self.modelfilename="spells/cfx_monk_chiorbit_missile.m2"	
	-- self.yoffset=0	
	-- self.cameradistance=3
	-- self.framescale=6
	-- -- moving spelleffect parameters:
	-- self.multiplierbase=250
	-- self.movingyoffset=0
	-- self.mobilexmodifier=1.3
	-- self.mobilexmultipliermodifier=0.075
	-- self.mobileymodifier=1.45
	-- self.mobileymultipliermodifier=0.075
	
	-- self.modelfilename="spells/cfx_hunter_aimedshot_missile.m2"
	
end

function TRAININGGROUNDS_Drawable_SpellEffect:CreateFrame()
	self.frame=TRAININGGROUNDS_ReusableModelFrames:GetFrame()
	self.frame:Show()
end

function TRAININGGROUNDS_Drawable_SpellEffect:SetFrameAppearance()	
	self.modelinfo=TRAININGGROUNDS_ModelInfo.new()
	self.modelinfo:Setup()

	--self.frame:SetModel("spells/cfx_druid_solarwrath_missile.m2")	-- ok
	--self.frame:SetModel("spells/cfx_hunter_aimedshot_missile.m2")	-- no
	--self.frame:SetModel("spells/cfx_mage_frostbolt_missile.m2")	-- doesn't load
	--self.frame:SetModel("spells/cfx_mage_arcanebarrage_missile.m2")	-- doesn't load
	--self.frame:SetModel("spells/cfx_mage_arcanemissiles_missile.m2")	-- doesn't load
	--self.frame:SetModel("spells/cfx_monk_chiorbit_missile.m2")	-- no
	self.frame:SetModel(self.modelfilename)
	
end

function TRAININGGROUNDS_Drawable_SpellEffect:ArrangeFrame(parentanchor,x,y,wid,hgt,yaw,pitch)
	if(self.moving and wid>=self.minsize)then
		self:ArrangeFrameMoving(parentanchor,x,y,wid,hgt,yaw,pitch)
	else		
		self:ArrangeFrameStationary(parentanchor,x,y,wid,hgt,yaw,pitch)
	end
end

function TRAININGGROUNDS_Drawable_SpellEffect:ArrangeFrameStationary(parentanchor,x,y,wid,hgt,yaw,pitch)
	--print(self.parentframe)
	self.frame:SetParent(self.parentframe)
	self.frame:ClearAllPoints()	
	self.frame:SetPoint(self.anchor,self.parentframe,parentanchor,x,y)	
	self.frame:SetCamDistanceScale(self.cameradistance)
	self.frame:SetPosition(0,0,self.yoffset)	--this line was marked as dubious

	self:SetFrameSizeAndOrientationStationary(wid,hgt,yaw,pitch)
end

--TODO: merge with charactermodel
function TRAININGGROUNDS_Drawable_SpellEffect:SetFrameSizeAndOrientationStationary(wid,hgt,yaw,pitch)
	--wid and hgt are assumed to be redundant for charactermodels; only wid is used.
	local hgt=wid	
	local framescale=self.framescale
	local multiplier=framescale
	self.frame:SetSize(wid*multiplier,hgt*multiplier)
end



function TRAININGGROUNDS_Drawable_SpellEffect:ArrangeFrameMoving(parentanchor,x,y,wid,hgt,yaw,pitch)
	--TODO: parentanchor currently ignored; always center

	self.frame:SetParent(self.parentframe.scrollframe)
	--self.frame:SetParent(UIParent)
	self.frame:ClearAllPoints()
	self.frame:SetPoint("CENTER",self.owner.environment.frame.scrollframe,"CENTER",0,0)
	local hh=self.owner.environment.frame:GetHeight()
	local scale=(wid/self.minsize)

	self.frame:SetWidth(hh*scale)
	self.frame:SetHeight(hh*scale)

	
	--wid and hgt are assumed to be redundant for charactermodels; only wid is used.
	local hgt=wid

	local xx=x-self.owner.environment.frame.scrollframe:GetHorizontalScroll()
	local yy=y-(-self.owner.environment.frame.scrollframe:GetVerticalScroll())

	local xfrac=(xx/self.parentframe:GetWidth())*2/scale
	local yfrac=(yy/self.parentframe:GetHeight())*2/scale
	local x,y=xfrac,yfrac

	
	-- This multiplier affects SetCamDistanceScale.
	-- The SMALLER multiplier is, the LARGER the effect will appear.
	local divwid=wid;if(divwid<0.25)then divwid=0.25 end
	local minscale=(self.minscale)
	local divscale=minscale; if(divscale<0.25)then divscale=0.25 end
	local multiplier2=minscale*0.8

	local xmultiplier=multiplier2*(self.mobilexmodifier+self.mobilexmultipliermodifier/divscale)
	local ymultiplier=multiplier2*(self.mobileymodifier+self.mobileymultipliermodifier/minscale)
	
	ymultiplier=ymultiplier-(y*.08*minscale)
	xmultiplier=xmultiplier-(y*.095*minscale)
	
	self.frame:SetCamDistanceScale(80)
	--self.frame:SetPosition(-150,x*xmultiplier,-80+self.movingyoffset+y*ymultiplier)
	self.frame:SetPosition(0,x*xmultiplier,0+self.movingyoffset+y*ymultiplier)
		
end


function TRAININGGROUNDS_Drawable_SpellEffect:ArrangeFrameMoving_Old3(parentanchor,x,y,wid,hgt,yaw,pitch)
	--TODO: parentanchor currently ignored; always center

	self.frame:SetParent(self.parentframe.scrollframe)
	self.frame:ClearAllPoints()
	self.frame:SetPoint("CENTER",self.owner.environment.frame.scrollframe,"CENTER",0,0)
	self.frame:SetWidth(self.owner.environment.frame:GetHeight())
	self.frame:SetHeight(self.owner.environment.frame:GetHeight())

	
	--wid and hgt are assumed to be redundant for charactermodels; only wid is used.
	local hgt=wid

	local xx=x-self.owner.environment.frame.scrollframe:GetHorizontalScroll()
	local yy=y-(-self.owner.environment.frame.scrollframe:GetVerticalScroll())

	local xfrac=(xx/self.parentframe:GetWidth())*2
	local yfrac=(yy/self.parentframe:GetHeight())*2	
	local x,y=xfrac,yfrac

	
	--local multiplier=80
	-- This multiplier affects SetCamDistanceScale.
	-- The SMALLER multiplier is, the LARGER the effect will appear.
	local divwid=wid;if(divwid<0.25)then divwid=0.25 end
	local multiplier=(self.multiplierbase/wid)
	local divmultiplier=multiplier; if(divmultiplier<0.25)then divmultiplier=0.25 end
	local multiplier2=multiplier*0.8

	local xmultiplier=multiplier2*(1+0.5/divmultiplier)
	local ymultiplier=multiplier2*(1.2+0.5/multiplier)

	
	ymultiplier=ymultiplier-(y*.08*multiplier)
	xmultiplier=xmultiplier-(y*.095*multiplier)
	
	self.frame:SetCamDistanceScale(multiplier)
	self.frame:SetPosition(z,x*xmultiplier,self.movingyoffset+y*ymultiplier)
		
end

----------------------------------------------
----------------------------------------------
----------------------------------------------
----------------------------------------------
----------------------------------------------


function TRAININGGROUNDS_Drawable_SpellEffect:ArrangeFrameMoving(parentanchor,x,y,wid,hgt,yaw,pitch)
	--TODO: parentanchor currently ignored; always center

	self.frame:SetParent(self.parentframe.scrollframe)
	self.frame:ClearAllPoints()
	self.frame:SetPoint("CENTER",self.owner.environment.frame.scrollframe,"CENTER",0,0)
	self.frame:SetWidth(self.owner.environment.frame:GetHeight())
	self.frame:SetHeight(self.owner.environment.frame:GetHeight())

	
	--wid and hgt are assumed to be redundant for charactermodels; only wid is used.
	local hgt=wid

	local xx=x-self.owner.environment.frame.scrollframe:GetHorizontalScroll()
	local yy=y-(-self.owner.environment.frame.scrollframe:GetVerticalScroll())

	local xfrac=(xx/self.parentframe:GetWidth())*2
	local yfrac=(yy/self.parentframe:GetHeight())*2	
	local x,y=xfrac,yfrac

	
	--local multiplier=80
	-- This multiplier affects SetCamDistanceScale.
	-- The SMALLER multiplier is, the LARGER the effect will appear.
	local divwid=wid;if(divwid<0.25)then divwid=0.25 end
	local multiplier=(self.multiplierbase/wid)
	local divmultiplier=multiplier; if(divmultiplier<0.25)then divmultiplier=0.25 end
	local multiplier2=multiplier*0.8

	local xmultiplier=multiplier2*(self.mobilexmodifier+self.mobilexmultipliermodifier/divmultiplier)
	local ymultiplier=multiplier2*(self.mobileymodifier+self.mobileymultipliermodifier/multiplier)

	
	ymultiplier=ymultiplier-(y*.08*multiplier)
	xmultiplier=xmultiplier-(y*.095*multiplier)
	
	self.frame:SetCamDistanceScale(multiplier)
	self.frame:SetPosition(z,x*xmultiplier,self.movingyoffset+y*ymultiplier)
		
end